package cn.com.duiba.oto.oto.service.api.remoteservice.pay;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.param.oto.pay.request.alipay.AliPayLiteChargeRequest;
import cn.com.duiba.oto.param.oto.pay.response.alipay.AliPayChargeNotifyResponse;
import cn.com.duiba.oto.param.oto.pay.response.alipay.AliPayLiteChargeResponse;

import java.util.Map;

/**
 * 支付宝支付相关
 *
 * @author xiaotian
 * @date 2023/11/1 4:40 下午
 **/
@AdvancedFeignClient
public interface RemoteAliPayService {

    /**
     * 支付宝支付收单接口
     *
     * @param chargeRequest
     * @return
     * @throws BizException
     */
    AliPayLiteChargeResponse createAliPayCharge(AliPayLiteChargeRequest chargeRequest) throws BizException;


    /**
     * 支付宝回调  支付/退款 在同一个回调处理
     *
     * @param requestMap
     * @return
     */
    AliPayChargeNotifyResponse alipayNotify(Map<String, String> requestMap);
}
