package cn.com.duiba.oto.param.oto.pay.request.alipay;

import cn.com.duiba.oto.annotation.FieldMapKey;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author 吴文哲
 * @date 2020-07-14 11:04
 **/
@Data
public class AlipayBaseRequestParam implements Serializable {

    private static final long serialVersionUID = 7218207522027800769L;
    /**
     * 公钥
     */
    @FieldMapKey("public_key")
    @NotBlank(message = "publicKey 不能为空")
    private String publicKey;

    /**
     * 支付宝公钥
     */
    @FieldMapKey("alipay_public_key")
    @NotBlank(message = "alipay_public_key 不能为空")
    private String alipayPublicKey;


    /**
     * 私钥
     */
    @FieldMapKey("private_key")
    @NotBlank(message = "private_key 不能为空")
    private String privateKey;

    /**
     * 支付宝分配给开发者的应用ID
     */
    @FieldMapKey("app_id")
    @NotBlank(message = "appid 不能为空")
    @Size(max = 32, message = "appid 过长")
    private String appId;
}
