/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.dto.oto.amount;

import cn.com.duiba.oto.dto.oto.amount.ExpireAmountRecordDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class UserRemainAmountDto
implements Serializable {
    private static final long serialVersionUID = 16540625622786852L;
    private long remainAmount;
    private List<ExpireAmountRecordDto> effectiveAmountRecords;

    public long getRemainAmount() {
        return this.remainAmount;
    }

    public void setRemainAmount(long remainAmount) {
        this.remainAmount = remainAmount;
    }

    public List<ExpireAmountRecordDto> getEffectiveAmountRecords() {
        return this.effectiveAmountRecords;
    }

    public void setEffectiveAmountRecords(List<ExpireAmountRecordDto> effectiveAmountRecords) {
        this.effectiveAmountRecords = effectiveAmountRecords;
    }

    public List<ExpireAmountRecordDto> getAppointAmountRecords(Long amount) {
        if (amount > this.remainAmount || this.remainAmount <= 0L) {
            return Collections.emptyList();
        }
        List recordDtos = this.effectiveAmountRecords.stream().sorted(Comparator.comparing(ExpireAmountRecordDto::getExpireTime)).collect(Collectors.toList());
        ArrayList<ExpireAmountRecordDto> newRecordDtos = new ArrayList<ExpireAmountRecordDto>();
        AtomicLong incr = new AtomicLong(0L);
        for (ExpireAmountRecordDto recordDto : recordDtos) {
            newRecordDtos.add(recordDto);
            if (incr.addAndGet(recordDto.getRemainAmount()) < amount) continue;
            break;
        }
        return newRecordDtos;
    }
}

