package cn.com.duiba.oto.enums.activity;

import cn.com.duiba.oto.bean.activity.biz.BaseParamBean;
import cn.com.duiba.oto.bean.activity.biz.PhotoParamBean;
import cn.com.duiba.oto.bean.activity.biz.YiYuanParamBean;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * biz活动类型枚举
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum BizActivityTypeEnum {

    YI_YUAN(1, YiYuanParamBean.class),

    PHOTO(2, PhotoParamBean.class);;

    private static final Map<Integer, BizActivityTypeEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(BizActivityTypeEnum::getType, Function.identity(), (v1, v2) -> v1)));
    ;


    private final Integer type;

    private final Class<? extends BaseParamBean> beanClass;

    BizActivityTypeEnum(Integer type, Class<? extends BaseParamBean> beanClass) {
        this.type = type;
        this.beanClass = beanClass;
    }

    public static BizActivityTypeEnum getByType(Integer type) {
        return INNER_MAP.getOrDefault(type, null);
    }

    public Integer getType() {
        return type;
    }

    public Class<? extends BaseParamBean> getBeanClass() {
        return beanClass;
    }
}
