package cn.com.duiba.oto.dto.oto.cust.custInterview.result;

import cn.com.duiba.oto.dto.oto.cust.custInterview.CustInterviewBaseBean;
import lombok.Data;

import java.io.Serializable;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-06-29 10:51
 */
@Data
public class CustInterviewResultBean<T extends CustInterviewBaseBean> implements Serializable {

    private static final long serialVersionUID = -3055659269908789465L;

    /**
     * 传入的参数bean
     */
    private T bean;

    /**
     * 导入结果
     */
    private Boolean success;

    /**
     * 错误原因
     */
    private String errorMsg;

    /**
     * 新增的面访那个记录id
     */
    private Long interviewId;

    /**
     * 导入成功
     */
    public static <T extends CustInterviewBaseBean> CustInterviewResultBean<T> success(T bean,Long interviewId){
        CustInterviewResultBean<T> resultBean = new CustInterviewResultBean<>();
        resultBean.setBean(bean);
        resultBean.setInterviewId(interviewId);
        resultBean.setSuccess(true);
        return resultBean;
    }

    /**
     * 导入失败
     */
    public static <T extends CustInterviewBaseBean> CustInterviewResultBean<T> failed(T bean, String message) {
        CustInterviewResultBean<T> resultBean = new CustInterviewResultBean<>();
        resultBean.setBean(bean);
        resultBean.setErrorMsg(message);
        resultBean.setSuccess(false);
        return resultBean;
    }
}
