package cn.com.duiba.oto.enums.activity;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 客户活动报名来源
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum ActivityRecordSourceEnum {

    /**
     * 自然流量
     */
    OWN(0, "自然流量"),
    /**
     * 分享获取
     */
    SHARE(1, "分享获取"),
    /**
     * 后台添加
     */
    BACK(2, "后台添加");

    private static final Map<Integer, ActivityRecordSourceEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ActivityRecordSourceEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    ;


    private final Integer code;
    private final String desc;

    ActivityRecordSourceEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityRecordSourceEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
