package cn.com.duiba.oto.oto.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.activity.apply.ActivityApplyCountDto;
import cn.com.duiba.oto.dto.oto.activity.apply.ActivityApplyDto;
import cn.com.duiba.oto.dto.oto.activity.apply.ActivityDto;
import cn.com.duiba.oto.dto.oto.activity.apply.ApplyActivityConfigDto;
import cn.com.duiba.oto.dto.oto.activity.apply.ApplyActivityPrizeConfigDto;
import cn.com.duiba.oto.param.oto.activity.apply.RemoteDelActivityRecordParam;
import cn.com.duiba.oto.param.oto.activity.apply.RemoteSaveActivityRecordParam;
import cn.com.duiba.oto.param.oto.activity.apply.RemoteSearchActivityApplyRecordParam;
import cn.com.duiba.oto.param.oto.activity.apply.RemoteSearchActivityParam;
import cn.com.duiba.oto.util.PageResult;

import java.util.List;

/**
 * 功能描述：申请活动相关
 *
 * @Auther: xiaotian
 * @Date: 2024/8/14 09:58
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteApplyActivityService {

    /**
     * 获取配置的活动列表
     *
     * @return
     */
    @Deprecated
    List<ApplyActivityConfigDto> activityList();

    /**
     * 获取配置的奖品列表
     *
     * @return
     */
    @Deprecated
    List<ApplyActivityPrizeConfigDto> prizeList();

    /**
     * 客户的参与记录
     *
     * @param userId
     * @return
     */
    List<ActivityApplyDto> applyList(Long userId);

    /**
     * 新增参与记录
     *
     * @param activityApplyDto
     * @return
     */
    int insert(ActivityApplyDto activityApplyDto) throws BizException;

    /**
     * 查询活动列表
     *
     * @param param
     * @return
     */
    PageResult<ActivityDto> queryActivityList(RemoteSearchActivityParam param);

    /**
     * 保存/更新活动
     *
     * @param activityDto
     * @return
     */
    Boolean saveOrUpdateActivity(ActivityDto activityDto) throws BizException;

    /**
     * 删除活动
     *
     * @param activityId
     * @return
     * @throws BizException
     */
    Boolean delActivity(Long activityId) throws BizException;


    /**
     * 查询活动列表根据id集合
     *
     * @param activityIds
     * @return
     */
    List<ActivityDto> findActivityByIds(List<Long> activityIds);

    /**
     * 查询活动参与记录
     *
     * @param param
     * @return
     */
    PageResult<ActivityApplyDto> queryActivityRecordList(RemoteSearchActivityApplyRecordParam param);

    /**
     * 新增报名
     */
    Boolean addActivityRecord(RemoteSaveActivityRecordParam param) throws BizException;

    /**
     * 删除报名
     */
    Boolean delActivityRecord(RemoteDelActivityRecordParam param) throws BizException;


    /**
     * 查询报名记录
     * 用户查询这个userId用户是否参与过该活动
     *
     * @param activityId
     * @param userId
     * @return
     */
    Integer selectCountByActivityAndUser(Long activityId, Long userId);


    /**
     * 查询报名记录
     *
     * @param activityId
     * @param userId
     * @return
     */
    List<ActivityApplyDto> selectByActivityAndUser(Long activityId, Long userId);

    /**
     * 活动报名统计
     *
     * @param activityIds
     * @return
     */
    List<ActivityApplyCountDto> countApply(List<Long> activityIds);

    /**
     * 活动报名统计(c端使用)
     *
     * @param activityIds
     * @return
     */
    List<ActivityApplyCountDto> countApplyForSeller(List<Long> activityIds, Long sellerId);

    /**
     * 活动报名列表(c端使用)
     *
     * @param activityId
     * @return
     */
    List<ActivityApplyDto> activityRecordListForSeller(Long activityId, Long sellerId);

    /**
     * 客户点击咨询活动报名按钮
     *
     * @param userId
     * @return
     */
    Boolean clickActivity(Long userId);
}
