package cn.com.duiba.oto.oto.service.api.remoteservice.audit;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.audit.InterviewAuditRecordDTO;
import cn.com.duiba.oto.param.oto.audit.InterviewAuditRecordSearchParam;
import cn.com.duiba.oto.util.PageResult;

/**
 * 描述：
 *
 * @author zhouziwu
 * @date 2022-04-21
 */
@AdvancedFeignClient
public interface RemoteOtoAuditRecordService {

    /**
     * 面访异常审核列表查询
     * @param param 参数
     * @return result
     */
    PageResult<InterviewAuditRecordDTO> getInterviewAuditRecordList(InterviewAuditRecordSearchParam param);

    /**
     * 审核接口
     * @param id 审批表id
     * @param businessId 业务id
     * @param auditState 审批类型
     * @return boolean
     */
    Boolean interviewAudit(Long id, Long businessId, Integer auditState);
}
