package cn.com.duiba.oto.param.oto.call;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-16 16:11
 */
@Data
public class YunkeCallbackParam implements Serializable {

    private static final long serialVersionUID = -6264425191050547146L;

    /**
     * 通话时间
     */
    private String createTime;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 客户id
     */
    private String customerId;

    /**
     * 通话记录id 主键
     */
    private String id;

    /**
     * 客户手机号
     */
    private String phone;

    /**
     * 时长 单位秒
     */
    private Long duration;

    /**
     * 录音url
     */
    private String recordUrl;

    /**
     * 二级标签
     */
    private String tipName;

    /**
     * 一级标签id
     */
    private Long tipType;

    /**
     * 一级标签文字
     */
    private String tipTypeString;

    /**
     * 通话备注
     */
    private String remark;

    /**
     * 0呼出 1呼入
     */
    private Integer direction;

    /**
     * 预约时间
     */
    private String nextContactTime;

    /**
     * 外呼id 使用接口外呼时返回的id
     */
    private String callId;

    /**
     * 是否接通
     */
    private boolean through;

    /**
     * 员工外呼手机号
     */
    private String simPhone;

    /**
     * 销售进度类型id（销售进度描述可以通过/open/customer/getSalesProgresses接口获取）
     */
    private Integer progress;

    /**
     * 响铃时长
     */
    private Integer ringSecond;

    /**
     * 开始响铃时间
     */
    private String ringTime;
}
