package cn.com.duiba.oto.param.oto.goods.order;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description
 * @Author huliangsheng
 * @Date 2024/8/14 16:24
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteSearchOrderParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 1873297733997784319L;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * userId
     */
    private Long userId;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 用户姓名
     */
    private String custName;

    /**
     * 订单时间(start)
     */
    private Date orderTimeStart;

    /**
     * 订单时间(end)
     */
    private Date orderTimeEnd;

    /**
     * 商品id
     */
    private List<Long> goodsIds;

}
