package cn.com.duiba.oto.dto.oto.cust;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2022/10/13 13:55
 * @Description:
 */
@Data
public class OtoCustDto implements Serializable {

    private static final long serialVersionUID = 7630247264568416244L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 客户所处资源池类型
     *
     * @see cn.com.duiba.oto.enums.cust.OtoCustPoolEnum
     */
    private Integer poolType;

    /**
     * 当前的所有跟进人（邀约，销售，专家）
     */
    private List<Long> allSellerIds;

    /**
     * 销售Id包含专家id (盘点列表数据权限)（包含已经放弃的操作人）
     */
    private List<Long> sellerIds;

    /**
     * 销售Id包含专家id (我的客户列表数据权限)
     */
    private List<Long> mySellerIds;

    /**
     * 销售Id包含专家id (我的客户列表数据权限（总监）)
     */
    private List<Long> myDirectorSellerIds;

    /**
     * 当前跟进邀约人id
     */
    private Long inviteId;

    /**
     * 销售Id
     */
    private Long sellerId;

    /**
     * 专家Id
     */
    private Long expertId;

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 见面次数
     */
    private Integer meetTimes = 0;

    /**
     * 盘点次数
     */
    private Integer checkTimes = 0;

    /**
     * 是否讲解计划书
     */
    private Integer commitPlanFlag = 0;

    /**
     * 最近盘客户时间
     */
    private String lastCheckTime;

    /**
     * 承接时间
     */
    private String assignTime;

    /**
     * 是否重点跟进
     */
    private Integer custStar = 0;

    /**
     * 是否高质量用户
     */
    private Integer inviteStar = 0;

    /**
     * 是否社区高客
     */
    private Integer communityStar = 0;

    /**
     * 最近一次见面时间
     */
    private String lastMeetTime;

    /**
     * 最早一次见面时间
     */
    private String fristMeetTime;

    /**
     * 联系次数
     */
    private Integer callTimes = 0;

    /**
     * 最近联系时间
     */
    private String lastCallTime;

    /**
     * 重点跟进人
     */
    private Integer followUp;

    /**
     * 见面场景配置ID
     */
    private List<Long> sceneIds;

    /**
     * 促单情况 0取消促单 1标记促单
     */
    private Integer promotionType;

    /**
     * 是否放弃  0否 1是
     */
    private Integer hasGiveUp = 0;

    /**
     * 是否只有邀约 0否 1是
     */
    private Integer hasInviteNotHasSellerAndExpert;

    /**
     * 标签id
     */
    private List<Long> tagIds = new ArrayList<>(1);

    /**
     * 参与直播的行为
     */
    private List<Integer> liveActions;

    /**
     * 参与直播id列表
     */
    private List<String> liveIds;

    /**
     * 是否上传kyc
     */
    private Integer isUploadKyc;

    /**
     * 是否上传方案
     */
    private Integer isUploadPlan;

    /**
     * kyc合格状态 0未上传 1合格 2不合格 3已上传无状态
     */
    private Integer kycStatus;

    /**
     * 是否上传风险评估报告 0否 1是
     */
    private Integer isUploadEvaluate;

    /**
     * 客户分类 1：未见面 2：已初次见面 3：已上传kyc 4：已上传风险评估报告 5：已上传方案 6：促单客户 7:已讲解方案客户
     */
    private Integer custType;

    /**
     * 上传kyc时间
     * 当前专家第一次面访后的第一次上传时间
     */
    private String uploadKycTime;

    /**
     * 上传方案时间
     * 当前专家第一次面访后的第一次上传时间
     */
    private String uploadPlanTime;

    /**
     * 上传上传风险评估报告时间
     * 当前专家第一次面访后的第一次上传时间
     */
    private String uploadEvaluateTime;

    /**
     * 讲解方案时间
     * 当前专家第一次面访后的第一次讲解时间
     */
    private String planExplainTime;

    /**
     * 客户手机号（包括）
     */
    private List<String> phones;

    /**
     * 客户来源（初次）
     *
     * @see cn.com.duiba.oto.enums.cust.CustFromSourceEnum
     */
    private String custFromSourceFrist;

    /**
     * 客户来源（最后一次）
     *
     * @see cn.com.duiba.oto.enums.cust.CustFromSourceEnum
     */
    private String custFromSourceLast;

    /**
     * 是否标记成单 0否 1是
     */
    private Integer dealFlag;

    /**
     * 脱落时间
     */
    private String separateTime;

    /**
     * 所属公司
     */
    private List<Long> companyIds;

    /**
     * 客户手机号归属地模糊查询
     */
    private String custArea;

    /**
     * 创建时间
     */
    private String gmtCreateTime;

    /**
     * 账户ID集合
     */
    private List<String> launchAccountIds;

    /**
     * 广告组名称
     */
    private String adgroupName;

    /**
     * 加微状态
     */
    private Integer addWxStatus;

    /**
     * 是否约到一面 0否 1是
     */
    private Integer firstInterviewFlag;

    /**
     * 脱落是否需要邀约查阅
     * 0：不需要 1：需要
     */
    private Integer separateCheckRead;

    /**
     * 创建人ID
     * 手动创建客户的创建人id
     */
    private Long createBy;

    /**
     * 客户类型（小程序端搜索使用）
     * 1：转介绍 2：缘故客户 3：数字客户
     *
     * @see cn.com.duiba.oto.enums.cust.CustWxSearchTypeEnum
     */
    private Integer custTypeSearch;
}
