package cn.com.duiba.oto.enums;

import com.google.common.collect.Sets;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Collections;
import java.util.Set;

/**
 * @author liuyj
 * @date 2022/8/5 09:59
 */
@Getter
@AllArgsConstructor
public enum InvitationStatusEnum {
    TO_ASSIGN_TO_CONFIRM(1, 1,"待分配（待确认）"),
    TO_ASSIGN_CONFIRM(2, 2,"待分配（已确认）"),
    TO_ASSIGN_TO_DOVE(3, 4,"待分配（已鸽）"),
    ASSIGN_TO_PRESENT(4, 5,"已分配（预期到场）"),
    ASSIGN_PRESENT(5, 6,"已分配（已到场）"),
    /**
     * 已改期只是前端展示使用，后端数据库不作存储
     */
    TO_ASSIGN_RESCHEDULE(6, 3,"待分配（已改期）"),
    ;

    /**
     * 表明此次邀约已经终结的状态
     */
    public static final Set<Integer> END_STATUS = Collections.unmodifiableSet(Sets.newHashSet(ASSIGN_PRESENT.getCode(), TO_ASSIGN_TO_DOVE.getCode()));

    private Integer code;

    private Integer order;

    private String desc;

    public static InvitationStatusEnum getByCode(Integer code) {
        for (InvitationStatusEnum invitationStatusEnum : InvitationStatusEnum.values()) {
            if (invitationStatusEnum.getCode().equals(code)) {
                return invitationStatusEnum;
            }
        }
        return null;
    }
}
