package cn.com.duiba.oto.enums.amount;

/**
 * 过期状态
 *
 * @author songp
 * @date 2024/8/14 11:34 AM
 */
public enum ExpireStatusEnum {

    // 过期状态:0:未过期,1:已过期
    NOT_EXPIRE(0L,"未过期"),

    EXPIRED(1L, "已过期");

    private final Long status;

    private final String desc;

    ExpireStatusEnum(Long status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Long getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }
}
