package cn.com.duiba.oto.oto.service.api.remoteservice.goods.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.goods.order.ApplyRefundParam;
import cn.com.duiba.oto.dto.oto.goods.order.OrderCountDto;
import cn.com.duiba.oto.dto.oto.goods.order.OrderDetail;
import cn.com.duiba.oto.dto.oto.goods.order.OrderListVO;
import cn.com.duiba.oto.dto.oto.goods.order.PayDto;
import cn.com.duiba.oto.dto.oto.goods.order.RefundGoodOrderParam;
import cn.com.duiba.oto.param.oto.goods.RemoteGenerateOrderParam;
import cn.com.duiba.oto.param.oto.goods.order.RemoteAppiontmentTimeParam;
import cn.com.duiba.oto.param.oto.goods.order.RemoteSearchOrderParam;
import cn.com.duiba.oto.util.PageResult;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * @Description 订单接口
 * @Author huliangsheng
 * @Date 2024/8/14 15:45
 */
@AdvancedFeignClient
public interface RemoteOrderService {

    /**
     * 订单列表
     */
    DubboResult<PageResult<OrderListVO>> list(RemoteSearchOrderParam param);

    /**
     * 订单详情
     */
    DubboResult<OrderDetail> detail(Long id);

    /**
     * 核销
     * 核销时间，默认当前时间
     */
    Boolean verify(Long id);

    /**
     * 核销
     */
    Boolean verify4Time(Long id, Date time);

    /**
     * 退款
     */
    DubboResult<Boolean> refund(RefundGoodOrderParam param);

    /**
     * 订单申请退款(C端退款)
     */
    DubboResult<Boolean> applyRefund(ApplyRefundParam param);

    /**
     * 生成商品订单
     */
    DubboResult<PayDto> orderGoods(RemoteGenerateOrderParam param);

    /**
     * 批量修改预约领取时间
     */
    int updateAppointmentTime(RemoteAppiontmentTimeParam param);

    /**
     * 修改领取方式
     */
    int updateReceiveType(Long id, Integer receiveType);

    /**
     * 查询用户订单统计
     *
     * @param userId
     * @return
     */
    List<OrderCountDto> countUserByOrderStatus(Long userId);

    /**
     * 查询未领取订单数量
     * 订单状态为已支付
     *
     * @param userIds
     * @return
     */
    List<OrderCountDto> countUserNotReceive(List<Long> userIds);

    /**
     * 查询可领取订单数量
     * 订单状态为已支付，并且商品有实际库存
     *
     * @param userIds
     * @return
     */
    List<OrderCountDto> countUserCanReceive(List<Long> userIds);

}
