package cn.com.duiba.oto.dto.oto.auth;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 系统接口表
 *
 * @TableName tb_oto_api_mapping
 */
@Data
public class ApiMappingDto implements Serializable {

    private static final long serialVersionUID = -8634709014117777635L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 系统名称
     */
    private String systemName;

    /**
     * 接口路径
     */
    private String urlPath;

    /**
     * HTTP 方法 (GET, POST, PUT, DELETE 等)
     */
    private String httpMethod;

    /**
     * 接口描述
     */
    private String description;

    /**
     * 处理器类及方法 (如 UserController#getAllUsers)
     */
    private String handler;

    /**
     * 最后调用时间
     */
    private Date lastTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}