package cn.com.duiba.oto.oto.service.api.remoteservice.content;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.content.ContentDto;
import cn.com.duiba.oto.dto.oto.content.UserContentDto;
import cn.com.duiba.oto.param.oto.content.ContentListUserParam;
import cn.com.duiba.oto.param.oto.content.ContentUserParam;
import cn.com.duiba.oto.param.oto.content.ContentVideoPageForMngParam;
import cn.com.duiba.oto.param.oto.content.ContentVideoPageParam;
import cn.com.duiba.oto.util.PageResult;

import java.util.List;

/**
 * OTO-内容相关
 *
 * @author xiaotian
 * @date 2024/8/06 14:51
 */
@AdvancedFeignClient
public interface RemoteContentService {

    /**
     * 获取视频列表
     *
     * @param contentVideoPageParam
     * @return
     */
    List<ContentDto> pageContent(ContentVideoPageParam contentVideoPageParam);


    /**
     * 分页查询(管理后台)
     *
     * @param param
     * @return
     */
    PageResult<ContentDto> pageContentForMng(ContentVideoPageForMngParam param);

    /**
     * 新增内容
     * @param contentDto
     * @return
     */
    Boolean addContent(ContentDto contentDto);

    /**
     * 更新内容
     * @param contentDto
     * @return
     */
    Boolean updateContent(ContentDto contentDto);
    /**
     * 切换上下架
     * @param id
     * @param status
     * @return
     */
    Boolean switchShelf(Long id, Integer status);

    /**
     * 获取所有视频
     *
     * @return
     */
    @Deprecated
    List<ContentDto> getAllVideo(Long userId);

    /**
     * 获取所有视频id
     *
     * @param userId
     * @return
     */
    List<Long> getAllVideoIds(Long userId);


    /**
     * 根据id批量查询内容详情
     *
     * @param ids
     * @return
     */
    List<ContentDto> findByIds(List<Long> ids);

    /**
     * 获取内容详情
     *
     * @param param
     * @return
     */
    ContentDto contentDetail(ContentUserParam param);

    /**
     * 阅读内容
     */
    Boolean readContent(ContentUserParam param);

    /**
     * 点赞内容
     */
    Boolean starContent(ContentUserParam param);


    /**
     * 根据用户id和内容id查询
     */
    UserContentDto getByUserIdAndContentId(ContentUserParam param);

    /**
     * 批量查询用户内容信息
     *
     * @param param
     * @return
     */
    List<UserContentDto> batchGetByUserIdAndContentId(ContentListUserParam param);
}
