package cn.com.duiba.oto.oto.service.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.live.OtoLiveClueDto;
import cn.com.duiba.oto.dto.oto.live.OtoLiveDto;
import cn.com.duiba.oto.dto.oto.live.OtoLiveLastSellerDto;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-02-16 09:45
 */
@AdvancedFeignClient
public interface RemoteLiveCustService {

    /**
     * 获取直播线索列表
     *
     * @param custId
     * @return
     */
    List<OtoLiveClueDto> findByCustId(Long custId);

    /**
     * 观看直播的场次
     *
     * @param custId
     * @return
     */
    int liveCount(Long custId);

    /**
     * 根据直播title，获取直播列表（左匹配）
     *
     * @param title
     * @return
     */
    List<OtoLiveDto> findByTitle(String title);

    /**
     * 根据直播id获取直播详情
     *
     * @param liveIds
     * @return
     */
    List<OtoLiveDto> findByLiveIds(List<String> liveIds);

    /**
     * 获取最近的邀约代理人（销售）
     *
     * @param custIds
     * @return
     */
    List<OtoLiveLastSellerDto> findLastSellerByCustId(List<Long> custIds);
}
