package cn.com.duiba.oto.param.oto.cust.form;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：新增表单详情参数
 *
 * @Auther: xiaotian
 * @Date: 2023/2/27 09:25
 * @Description:
 */
@Data
public class RemoteCustFormSaveDetailParam implements Serializable {
    private static final long serialVersionUID = 4283727048158239016L;

    /**
     * 表单id
     */
    private Long id;

    /**
     * 表单名称
     */
    private String title;

    /**
     * 问题列表
     */
    private List<FormQuestionParam> formQuestions;


    @Data
    public static class FormQuestionParam implements Serializable {

        private static final long serialVersionUID = -1559448868275382189L;

        /**
         * 问题id
         */
        private Long id;

        /**
         * 问题code（前端定义）
         */
        private String code;

        /**
         * 标题
         */
        private String title;

        /**
         * 问题类型 select ｜ input
         */
        private String type;


        private boolean multi = false;

        /**
         * 是否日期格式
         */
        private boolean date = false;

        /**
         * 选项列表
         */
        private List<QuestionOptionParam> options;

    }

    @Data
    public static class QuestionOptionParam implements Serializable {

        private static final long serialVersionUID = -5742187931117014150L;

        /**
         * 选项code
         */
        private String code;

        /**
         * 选项标题
         */
        private String title;

        /**
         * 类型 normal / other
         */
        private String type;
    }
}
