package cn.com.duiba.oto.param.oto.pay.request.alipay;

import cn.com.duiba.oto.annotation.FieldMapKey;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 支付宝 通用请求参数
 *
 * @author xiaotian
 * @date 2020-07-10 15:11
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class AliPayCommonRequest extends AlipayBaseRequestParam implements Serializable {
    private static final long serialVersionUID = 1408811867383148242L;

    /**
     * 接口名称
     */
    @FieldMapKey("method")
    @NotBlank(message = "method 不能为空")
    @Size(max = 128, message = "method 过长")
    private String method;

    /**
     * JSON
     */
    @FieldMapKey("format")
    @Size(max = 40, message = "format 过长")
    private String format;

    /**
     * 请求使用的编码格式，如utf-8,gbk,gb2312等
     */
    @FieldMapKey("charset")
    @NotBlank(message = "charset 不能为空")
    @Size(max = 10, message = "charset 过长")
    private String charset;

    /**
     * 商户生成签名字符串所使用的签名算法类型，目前支持RSA2和RSA，推荐使用RSA2
     */
    @FieldMapKey("sign_type")
    @NotBlank(message = "sign_type 不能为空")
    @Size(max = 10, message = "sign_type 过长")
    private String signType;

    /**
     * 商户请求参数的签名串
     */
    @FieldMapKey("sign")
    @NotBlank(message = "sign 不能为空")
    @Size(max = 344, message = "sign 过长")
    private String sign;

    /**
     * 发送请求的时间，格式"yyyy-MM-dd HH:mm:ss"
     */
    @FieldMapKey("timestamp")
    @NotBlank(message = "timestamp 不能为空")
    @Size(max = 19, message = "timestamp 过长")
    private String timestamp;

    /**
     * 调用的接口版本，固定为：1.0
     */
    @FieldMapKey("version")
    @NotBlank(message = "version 不能为空")
    @Size(max = 3, message = "version 过长")
    private String version;

    /**
     * 支付宝服务器主动通知商户服务器里指定的页面http/https路径。
     */
    @FieldMapKey("notify_url")
    @Size(max = 256, message = "notify_url 过长")
    private String notifyUrl;

    /**
     * 应用授权概述
     */
    @FieldMapKey("app_auth_token")
    @Size(max = 40, message = "app_auth_token 过长")
    private String appAuthToken;

    /**
     * 请求参数的集合，最大长度不限，除公共参数外所有请求参数都必须放在这个参数中传递，具体参照各产品快速接入文档
     */
    @FieldMapKey("biz_content")
    @NotBlank(message = "biz_content 不能为空")
    private String bizContent;


}
