package cn.com.duiba.oto.dto.oto.seller;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 销售客户分配记录表
 * @author kjj mybatis generator 
 * @date 2022-03-17
 */
@Data
public class SellerAssignRecordDto implements Serializable {
     
    private static final long serialVersionUID = 16475049713378441L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 销售id, tb_oto_seller.id
     */
    private Long sellerId;

    /**
     * 客户id, tb_oto_customer.id
     */
    private Long custId;

    /**
     * 分配类型,1=管理员分配,2=销售主动从投放池认领,3=销售主动从回收池认领,4=系统强制分配
     *
     * @see cn.com.duiba.oto.enums.cust.follow.OtoCustAssignTypeEnum
     */
    private Integer assignType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    private Integer fromAssignType;

    private String assignOperator;
}