package cn.com.duiba.oto.dto.oto.activity.invite;

import lombok.Data;

import java.util.Date;

/**
 * 功能描述：转介绍活动详情
 *
 * @Auther: xiaotian
 * @Date: 2025/2/25 16:51
 * @Description:
 */
@Data
public class InvitedUserDetailDto {
    // 被邀请人昵称：展示被邀请人的小程序昵称
    private String nickname;
    // 出生日期：展示被邀请人填写的出生日期
    private String birthDate;
    // 被邀请人姓名：若被邀请人已在系统内入库，则展示被邀请人姓名，若未入库则显示“-”
    private String name;
    // 被邀请人id：若被邀请人已在系统内入库，则展示被邀请人id，若未入库则显示“-”
    private Long id;
    // 是否下单：展示该用户是否在小程序商城内下单
    private boolean hasOrdered;
    // 下单商品：若该用户下单则展示首次购买商品的名称，未下单则展示“-”
    private String firstOrderInfo;
    // 下单时间：若该用户下单则展示首次下单时间，年月日，未下单则展示“-”
    private String firstOrderTime;
    // 是否领取：判断该用户是否结单，若已结单则展示“是”，并下方标出领取时间年月日
    private boolean hasClaimed;
    // 领取时间：若已结单则展示领取时间年月日
    private Date claimTime;
    // 是否到场：判断该用户是否有面访记录，若有则展示“是”，并下方标出首次到场时间年月日
    private boolean hasVisited;
    // 首次到场时间：若已到场则展示首次到场时间年月日
    private Date visitTime;
    // 已奖励邀请人立减金：统计该被邀请人参与活动，奖励给邀请人的立减金总金额
    private long totalRewardToInviter;
}
