package cn.com.duiba.oto.dto.oto.amount.enums;

/**
 * 立减金来源
 *
 * @author songp
 * @date 2024/8/14 11:22 AM
 */
public enum SourceFromEnum {

    // 1、观看视频获取 2、签到获取 3、官方赠送
    VIDEO("1", "视频观看奖励"),
    SIGN("2", "我的签到礼品"),
    OFFICE("3", "官方赠送"),
    INVITE_INVITEE_SUBMIT("4", "官方赠送"),
    INVITE_INVITER_SUBMIT("5", "官方赠送"),
    INVITE_INVITER_ORDER("6", "官方赠送"),
    INVITE_INVITER_COMPELETE("7", "官方赠送"),
    ;

    private final String type;

    private final  String source;

    SourceFromEnum(String type, String source) {
        this.type = type;
        this.source = source;
    }

    public String getType() {
        return type;
    }

    public String getSource() {
        return source;
    }

    public static SourceFromEnum getByType(String type) {
        for (SourceFromEnum sourceFromEnum : SourceFromEnum.values()) {
            if (sourceFromEnum.getType().equals(type)) {
                return sourceFromEnum;
            }
        }
        return null;
    }
}
