package cn.com.duiba.oto.oto.service.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.activity.ActivityConfigDto;
import cn.com.duiba.oto.dto.oto.activity.ActivityConfigV2Dto;
import cn.com.duiba.oto.dto.oto.activity.ActivityRecordDto;
import cn.com.duiba.oto.param.oto.activity.ActivitySearchParam;

import java.util.List;

/**
 * 功能描述：活动相关
 *
 * @Auther: xiaotian
 * @Date: 2023/1/30 09:58
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteActivityService {

    /**
     * 获取配置的活动列表
     *
     * @return
     */
    List<ActivityConfigDto> activityList();

    /**
     * 保存活动参与记录
     *
     * @param activityRecordDto
     * @return
     */
    int insert(ActivityRecordDto activityRecordDto);

    /**
     * 保存活动参与记录
     */
    int save(ActivityRecordDto activityRecordDto);

    /**
     * 根据用户id和活动id，获取参与记录
     *
     * @param userId
     * @param activityId
     * @return
     */
    List<ActivityRecordDto> selectByUserAndActivity(Long userId, Long activityId);

    /**
     * 根据用户id或者客户手机号和活动id，获取参与记录
     *
     * @param param
     * @return
     */
    List<ActivityRecordDto> searchActivityRecord(ActivitySearchParam param);

    /**
     * 根据用户id，删除活动参与记录
     *
     * @param userId
     * @return
     */
    int deleteByUserId(Long userId);

    /**
     * 有效的活动配置
     *
     * @return
     */
    ActivityConfigV2Dto validActivity();

    /**
     * 执行任务
     * 统计签到任务发送至钉钉群的任务
     *
     * @param time
     * @return
     */
    boolean doTask(String time);

}
