package cn.com.duiba.oto.oto.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.activity.invite.ActivityUserDetailsDto;
import cn.com.duiba.oto.dto.oto.activity.invite.InviteUserDto;
import cn.com.duiba.oto.dto.oto.activity.invite.InvitedUserDetailDto;
import cn.com.duiba.oto.dto.oto.activity.invite.InviterDetailsDto;
import cn.com.duiba.oto.dto.oto.activity.invite.OtoInviterDetailDto;
import cn.com.duiba.oto.dto.oto.activity.invite.OtoInviterRecordDto;
import cn.com.duiba.oto.param.oto.activity.invite.RemoteClaimGiftParam;
import cn.com.duiba.oto.param.oto.activity.invite.RemoteQueryUserParam;
import cn.com.duiba.oto.param.oto.activity.invite.RemoteRecordAwardParam;
import cn.com.duiba.oto.param.oto.activity.invite.RemoteRecordSearchParam;
import cn.com.duiba.oto.param.oto.activity.invite.RemoteRecordUserParam;
import cn.com.duiba.oto.param.oto.common.PageQuery;
import cn.com.duiba.oto.util.PageResult;

import java.util.List;

/**
 * 功能描述：转介绍活动相关
 *
 * @Auther: xiaotian
 * @Date: 2025/02/26 09:58
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteInviteActivityService {

    /**
     * 邀请人列表搜索接口
     *
     * @param param 搜索请求对象，包含搜索条件
     * @return 包含邀请人列表的分页结果
     */
    PageResult<OtoInviterRecordDto> searchActivityRecord(RemoteRecordSearchParam param);

    /**
     * 查看邀请人详情接口
     *
     * @param userIds 邀请人的唯一标识符
     * @return 包含邀请人详情的结果对象
     */
    List<OtoInviterDetailDto> selectByUserId(List<Long> userIds);

    /**
     * 邀请人详情内的被邀请人列表接口
     *
     * @param param 包含邀请人ID和其他相关信息的参数对象
     * @return 包含被邀请人列表的分页结果
     */
    PageResult<InvitedUserDetailDto> selectByUserAndActivity(RemoteRecordUserParam param);

    /**
     * 发放到场奖励接口
     *
     * @param param 包含邀请人ID和其他相关信息的参数对象
     * @return 发放奖励的结果对象
     */
    Boolean award(RemoteRecordAwardParam param) throws BizException;

    /**
     * 获取被邀请人活动详情（参与人）
     *
     * @return 包含被邀请人参与活动详情的结果对象
     */
    ActivityUserDetailsDto getInvitedUserActivityDetails(Long userId) throws BizException;

    /**
     * 用户领取礼包（参与人）
     *
     * @param param 包含用户ID及活动ID等必要信息的对象
     * @return 操作结果
     */
    Boolean claimGift(RemoteClaimGiftParam param) throws BizException;

    /**
     * 获取我的邀请列表（邀请人）
     *
     * @param param 搜索请求对象，包含搜索条件
     * @return 包含邀请人列表的分页结果
     */
    PageResult<InviteUserDto> getMyInvitations(RemoteQueryUserParam param);

    /**
     * 邀请人统计详情（邀请人）
     *
     * @return 包含邀请人列表的分页结果
     */
    InviterDetailsDto inviterDetail(Long userId);
}
