package cn.com.duiba.oto.oto.service.api.remoteservice.dingtalk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.bean.dingTalk.DingTalkContent;


/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-06-07 13:58
 */
@AdvancedFeignClient
public interface RemoteDingtalkService {

    /**
     * 发送钉钉机器人消息（注意频率，1分钟超过20次会被限流）
     *
     * @param url             钉钉机器人webhook，可以在钉钉群-智能群助手-对应机器人-webhook中找到
     * @param dingTalkContent 钉钉消息内容
     * @return 发送结果
     * @see cn.com.duiba.oto.bean.dingTalk.DingTalkContentBuilder
     */
    boolean sendRobot(String url, DingTalkContent dingTalkContent);
}
