package cn.com.duiba.oto.param.oto.rights;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xiaotian
 * @date 2023/9/06 13:40
 */
@Data
public class RightsPackageSaveParam implements Serializable {

    private static final long serialVersionUID = 3193593951825557079L;


    private Long id;
    /**
     * 权益包名称
     */
    private String packageName;

    private String backImg;

    private String imgPackage;
    /**
     * 启用状态: 1:启用 0:禁用
     */
    private Integer packageState;
    /**
     * 备注
     */
    private String packageRemark;
    /**
     * 绑定的权益列表
     */
    private List<RightsParam> rightsParams;


    @Data
    public static class RightsParam implements Serializable {

        private static final long serialVersionUID = -307334596003117990L;

        /**
         * 权益id
         */
        private Long rightsId;

        /**
         * 次数
         */
        private Integer times;

        /**
         * 是否启用
         * 1：启用 2：禁用
         */
        private Integer open;
    }

}