package cn.com.duiba.oto.param.oto.seller;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author chenzhenxing
 * @date 2022/3/27 5:38 下午
 */
@Data
public class SellerNotifyParam implements Serializable {
    private static final long serialVersionUID = -887976272969243227L;

    /**
     * 销售id,tb_oto_seller.id
     */
    private Long sellerId;

    /**
     * 客户id,tb_oto_customer.id
     */
    private Long custId;

    /**
     * 通知类型,0=其它通知,1=上传预约参观记录,2=强制分配客户,3=日程通知,4=社区预约参观通知
     */
    private Integer notifyType;

    /**
     * 通知完成情况,0=其它,1=未完成,2=已取消,3=已完成
     *
     * @see cn.com.duiba.oto.enums.OtoSellerNotifyStatusEnum
     */
    private Integer notifyStatus;

    /**
     * 通知时间
     */
    private Date notifyTime;

}
