/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.pet;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum PetDoorTypeEnum {
    PASSWORD_LOCK(1, "\u5bc6\u7801\u9501"),
    EXPRESS_CABINET(2, "\u5b58\u653e\u5feb\u9012\u67dc"),
    HOME_PERSON(3, "\u5bb6\u4e2d\u6709\u4eba"),
    OTHER(4, "\u5176\u4ed6");

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP;
    private Integer code;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private PetDoorTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(PetDoorTypeEnum.values()).collect(Collectors.toMap(PetDoorTypeEnum::getCode, PetDoorTypeEnum::getDesc, (v1, v2) -> v1)));
    }
}

