package cn.com.duiba.oto.dto.oto.pet.order;

import cn.com.duiba.oto.dto.oto.pet.RemoteOrderDetailDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2025/4/12 09:13
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteOrderDetailFeedDto extends RemoteOrderDetailBaseDto {

    private static final long serialVersionUID = -5883464348439539641L;

    // 服务项目
    private List<RemoteOrderDetailDto.ServiceItemVO> serviceItems;

    @Data
    public static class ServiceItemVO implements Serializable {
        private static final long serialVersionUID = 140816508008132118L;
        /**
         * 当天的宠物列表
         */
        List<RemoteOrderDetailDto.PetItemVO> petItemVOS;
        /**
         * 服务日期
         */
        private String serviceDate;
        /**
         * 开门方式：1=密码锁，2=存放快递柜，3=家中有人，4=其他
         *
         * @see cn.com.duiba.oto.enums.pet.PetDoorTypeEnum
         */
        private Integer doorType;
        /**
         * 服务时间段，如 "10:00-12:00"
         */
        private String timeRange;

        /**
         * 服务时间段：1=上午，2=下午，3=晚上
         * @see cn.com.duiba.oto.enums.pet.PetTimeSlotEnum
         */
        private Integer appointmentTimeSlot;

        /**
         * 服务价格，单位为分
         */
        private Long price;
        /**
         * 加价金额（节假日和非常规时间加价）
         */
        private Long addPrice;

        /**
         * 是否节假日
         */
        private Boolean holiday;

        /**
         * 是否常规时间
         */
        private Boolean regularTime;
    }


    @Data
    public static class PetItemVO implements Serializable {
        private static final long serialVersionUID = 380533467017577129L;
        /**
         * 宠物ID
         */
        private Long petId;
        /**
         * 宠物名称
         */
        private String petName;
    }
}
