package cn.com.duiba.oto.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 描述：告知书签署状态
 *
 * @author zhouziwu
 * @date 2022-05-26
 */
@AllArgsConstructor
@Getter
public enum OtoNotificationSignatureStateEnum {

    /** 待签名 */
    NO_SIGNATURE(0, "待签名"),

    /** 销售签名 */
    SELLER_SIGNATURE(1, "销售已签名"),

    /** 客户签名 */
    CUSTOMER_SIGNATURE(2, "客户已签名"),

    /** 销售客户都签名 */
    ALL_SIGNATURE(3, "销售客户都签名"),

    /** 已失效 */
    INVALID_SIGNATURE(4, "已失效"),

    ;

    private final Integer code;
    private final String desc;

    private static final Map<Integer, OtoNotificationSignatureStateEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoNotificationSignatureStateEnum::getCode, Function.identity(), (o, n) -> o)));

    public static OtoNotificationSignatureStateEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
