package cn.com.duiba.oto.oto.service.api.remoteservice.wx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.wx.user.WxSubscriberUserDto;

import javax.annotation.Nullable;
import java.util.List;

/**
 * 关注用户rpc服务接口
 *
 * @author xiaotian
 * @date 2020-06-29 16:26
 **/
@AdvancedFeignClient
public interface RemoteSubscriberUserService {
    
    /**
     * 批量查询公众号关注用户列表 最多一次查100条
     *
     * @param oaId 公众号ID
     * @param openIdList  公众号下的用户openId列表
     * @return
     */
    List<WxSubscriberUserDto> getOaSubscriberUserList(Long oaId, List<String> openIdList);

    /**
     * 查询单个用户的用户信息
     * @param oaId 公众号ID（已关注）
     * @param openId 微信用户加密ID
     * @return 用户信息。 null:查询失败
     */
    @Nullable
    WxSubscriberUserDto getWxSubscriberUser(Long oaId, String openId);
}
