package cn.com.duiba.oto.oto.service.api.remoteservice.medicine;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.medicine.MedicineConfigDto;
import cn.com.duiba.oto.dto.oto.medicine.MedicineImageConfigDto;
import cn.com.duiba.oto.dto.oto.medicine.MedicineOrderDto;
import cn.com.duiba.oto.dto.oto.medicine.MedicineUserDto;
import cn.com.duiba.oto.param.oto.medicine.MedicineAccountParam;
import cn.com.duiba.oto.param.oto.medicine.MedicineOrderParam;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-13 14:33
 */
@AdvancedFeignClient
public interface RemoteOtoMedicineService {

    /**
     * 保存客户账号
     *
     * @param param 查询参数
     * @return 是否有下一条
     */
    Long saveAccount(MedicineAccountParam param) throws BizException;


    /**
     * 根据用户账号，获取订单记录
     *
     * @param userId
     * @return
     */
    List<MedicineOrderDto> getOrderList(Long userId);


    /**
     * 是否存在订单
     *
     * @param userId
     * @return
     */
    Boolean hasOrder(Long userId);


    /**
     * 新增订单
     *
     * @param param
     * @return
     */
    Long saveOrder(MedicineOrderParam param) throws BizException;


    /**
     * 根据手机号获取账户详情
     *
     * @param phoneNum
     * @return
     */
    MedicineUserDto getAccount(String phoneNum);


    /**
     * 发送短信验证码
     *
     * @param phoneNum
     * @return
     */
    boolean sendMsg(String phoneNum) throws BizException;


    /**
     * 获取配置的药品信息
     *
     * @return
     */
    List<MedicineConfigDto> getConfigList();

    /**
     * 获取图片配置信息
     *
     * @return
     */
    MedicineImageConfigDto getImageConfig();
}
