package cn.com.duiba.oto.oto.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.activity.BizActivityRecordDto;
import cn.com.duiba.oto.dto.oto.activity.VoteCountDto;
import cn.com.duiba.oto.dto.oto.activity.wuye.WuyeActivityConfigDto;
import cn.com.duiba.oto.param.oto.activity.OrderFroYiYuanParam;
import cn.com.duiba.oto.param.oto.activity.biz.PhotoChoosePrizeParam;
import cn.com.duiba.oto.param.oto.activity.biz.PhotoSubmitParam;
import cn.com.duiba.oto.param.oto.activity.biz.RemoteWuyeActivityConfParam;
import cn.com.duiba.oto.param.oto.activity.biz.VotePhotoParam;
import cn.com.duiba.oto.param.oto.activity.biz.WuyeActivitySubmitParam;
import cn.com.duiba.oto.param.oto.pay.response.wxpay.WxPayLiteChargeResponse;

import java.util.List;

/**
 * 功能描述：活动相关
 *
 * @Auther: xiaotian
 * @Date: 2023/1/30 09:58
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteBizActivityService {

    /**
     * 添加活动记录
     *
     * @return
     */
    Boolean addRecord(BizActivityRecordDto bizActivityRecordDto);

    /**
     * 根据userId和活动类型查询活动记录
     *
     * @param userId
     * @param activityType
     * @return
     */
    BizActivityRecordDto selectByUserIdAndType(Long userId, String activityType);


    /**------------------------------------------------一元购---------------------------------------------------**/

    /**
     * 一元购下单
     *
     * @param orderFroYiYuanParam
     * @return
     */
    WxPayLiteChargeResponse orderForYiYuan(OrderFroYiYuanParam orderFroYiYuanParam) throws BizException;


    /**------------------------------------------------摄影投票报名-----------------------------------------------**/

    /**
     * 摄影投票
     *
     * @param votePhotoParam
     * @return
     */
    Boolean votePhoto(VotePhotoParam votePhotoParam) throws BizException;

    /**
     * 摄影报名
     *
     * @param votePhotoParam
     * @return
     */
    Boolean submitPhoto(PhotoSubmitParam votePhotoParam) throws BizException;

    /**
     * 摄影抽奖
     *
     * @param param
     * @return
     * @throws BizException
     */
    Boolean photoChoosePrize(PhotoChoosePrizeParam param) throws BizException;

    /**
     * 摄影投票统计
     *
     * @param activityType
     * @return
     */
    List<VoteCountDto> countVotePhoto(String activityType);


    /**------------------------------------------------物业活动-----------------------------------------------**/

    /**
     * 新建物业活动
     */
    Boolean createWuyeActivity(RemoteWuyeActivityConfParam param) throws BizException;

    /**
     * 获取物业活动配置
     */
    List<WuyeActivityConfigDto> getWuyeActivityConfig();

    /**
     * 发送短信验证码
     */
    Boolean sendWuyeMsg(String phone) throws BizException;

    /**
     * 物业活动报名
     *
     * @param param
     * @return
     */
    Boolean joinWuyeActivity(WuyeActivitySubmitParam param) throws BizException;
}
