package cn.com.duiba.oto.param.oto.wxwork;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 外部成员(客户)信息表
 * @author kjj mybatis generator 
 * @date 2022-10-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoExternalUserSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16651996672542662L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 外部联系人(客户)的userid
     */
    private String externalUserKey;

    /**
     * 外部联系人(客户)的名称
     */
    private String name;

    /**
     * 外部联系人（客户）头像
     */
    private String avatar;

    /**
     * 外部联系人的类型，1表示该外部联系人是微信用户，2表示该外部联系人是企业微信用户
     */
    private Byte type;

    /**
     * 外部联系人在微信开放平台的唯一身份标识（微信unionid）
     */
    private String unionid;

    /**
     * 添加了此外部联系人的企业成员userid(销售userid)
     */
    private String followUserKey;

    /**
     * 该成员(销售)对此外部联系人的备注
     */
    private String followUserRemark;

    /**
     * 该成员（销售）添加此外部联系人的时间
     */
    private Date followUserCreatetime;

    /**
     * 该成员(销售)对此客户备注的手机号码(数组)
     */
    private String followUserRemarkMobiles;

    /**
     * 该成员添加此客户的来源 0  未知来源 1  扫描二维码 2  搜索手机号 3  名片分享 4  群聊 5  手机通讯录 6  微信联系人 8  安装第三方应用时自动添加的客服人员 9  搜索邮箱 10  视频号添加 11  通过日程参与人添加 12  通过会议参与人添加 13  添加微信好友对应的企业微信 14  通过智慧硬件专属客服添加 201  内部成员共享 202  管理员/负责人分配
     */
    private Integer followUserAddWay;

    /**
     * 该成员添加此客户的来源add_way为10时，对应的视频号信息
     */
    private String followUserWechatChannels;

    /**
     * 视频号名称
     */
    private String followUserWechatChannelsNickname;

    /**
     * 视频号添加场景，0-未知 1-视频号主页 2-视频号直播间
     */
    private Byte followUserWechatChannelsSource;

    /**
     * 发起添加的userid，如果成员主动添加，为成员的userid；如果是客户主动添加，则为客户的外部联系人userid；如果是内部成员共享/管理员分配，则为对应的成员/管理员userid
     */
    private String followUserOperUserid;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}