package cn.com.duiba.oto.dto.oto.cust;

import lombok.Data;

import java.io.Serializable;

/**
 * 邀约客户账户统计数据DTO
 *
 * @author xiaotian
 * @date 2024/12/19
 */
@Data
public class InviteCustAccountStatDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 渠道
     */
    private Integer pubChannel;

    /**
     * 渠道描述
     */
    private String pubChannelDesc;

    /**
     * 账户ID
     */
    private String launchAccountId;

    /**
     * 账户名称
     */
    private String accountName;

    /**
     * 入库数
     */
    private Long inCount;

    /**
     * 联系数
     */
    private Long callCount;

    /**
     * 接通数
     */
    private Long connectCount;

    /**
     * 接通率（百分比，保留2位小数，带%符号）
     */
    private String connectRate;

    /**
     * 应邀数
     */
    private Long inviteCount;

    /**
     * 应邀率（百分比，保留2位小数，带%符号）
     */
    private String inviteRate;
}
