package cn.com.duiba.oto.dto.oto.cust.form;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：表单列表详情
 *
 * @Auther: xiaotian
 * @Date: 2023/2/27 09:07
 * @Description:
 */
@Data
public class CustFormDetailDto implements Serializable {
    private static final long serialVersionUID = -4456628455822134142L;

    /**
     * 表单id
     */
    private Long id;

    /**
     * 表单名称
     */
    private String title;

    /**
     * 问题列表
     */
    private List<FormQuestionDto> formQuestions;


    @Data
    public static class FormQuestionDto implements Serializable {

        private static final long serialVersionUID = -1559448868275382189L;

        /**
         * 资料表单id
         */
        private Long groupId;

        /**
         * 问题id
         */
        private Long id;

        /**
         * 问题code（前端定义）
         */
        private String code;

        /**
         * 标题
         */
        private String title;

        /**
         * 问题类型 select ｜ input
         */
        private String type;

        private boolean multi = false;

        /**
         * 是否日期格式
         */
        private boolean date = false;

        /**
         * 选项列表
         */
        private List<QuestionOptionDto> options;

        /**
         * 答案
         */
        private List<QuestionAnswerDto> answers;

    }

    @Data
    public static class QuestionOptionDto implements Serializable {

        private static final long serialVersionUID = -5742187931117014150L;

        /**
         * 问题id
         */
        private Long questionId;

        /**
         * 选项类型 normal ｜ other
         */
        private String type;

        /**
         * 选项code
         */
        private String code;

        /**
         * 选项标题
         */
        private String title;

    }

    @Data
    public static class QuestionAnswerDto implements Serializable {

        private static final long serialVersionUID = -5742187931117014150L;


        /**
         * 选项code
         */
        private String code;

        /**
         * 填写项
         * type === other 或者天空题时用户提交会有text字段
         */
        private String text;
    }

}
