package cn.com.duiba.oto.enums.cust;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 客户经营看板业务枚举
 *
 * @author MeiChang
 * @Description
 */
@Getter
public enum CustBulletinBoardStatisticsSubForAdvanceEnum {
    INTERVIEW(1, "面访总次数"),
    KYC(2, "上传kyc数"),
    RISK(3, "讲解风险报告数"),
    PLAN(4, "讲解方案数"),
    KICK(5, "踢单数")
    ;

    private static final Map<Integer, CustBulletinBoardStatisticsSubForAdvanceEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CustBulletinBoardStatisticsSubForAdvanceEnum::getCode, Function.identity(), (v1, v2)->v1)));;


    private final Integer code;
    private final String desc;

    CustBulletinBoardStatisticsSubForAdvanceEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CustBulletinBoardStatisticsSubForAdvanceEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code){
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
