package cn.com.duiba.oto.enums.activity;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动上下架标识
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum ActivityStatusEnum {

    /**
     * 活动开始
     */
    START(1, "上架"),
    /**
     * 活动结束
     */
    END(0, "下架");

    private static final Map<Integer, ActivityStatusEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ActivityStatusEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    ;


    private final Integer code;
    private final String desc;

    ActivityStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityStatusEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
