package cn.com.duiba.oto.enums.cust.form;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * OTO 资料组状态
 * -1：删除 0：停用，1：待发布 2：使用中
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum LibraryStatusEnum {

    DEL(-1, "删除"),
    CLOSE(0, "停用"),
    WAIT(1, "待发布"),
    PUBLISH(2, "使用中"),
    ;

    private static final Map<Integer, LibraryStatusEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(LibraryStatusEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    ;


    private final Integer code;
    private final String desc;

    LibraryStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static LibraryStatusEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
