package cn.com.duiba.oto.enums.form.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 公域引流-客户管理性别枚举
 *
 * @author xiaocong
 * @date 2021/11/17 7:51 下午
 */
@Getter
@AllArgsConstructor
public enum PubFormCustomerGenderEnum {

    /**
     * 未选择
     */
    NULL(0, ""),

    /**
     * 男
     */
    MAN(1, "男"),

    /**
     * 女
     */
    WOMAN(2, "女");

    /**
     * code
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String description;


    public static final Map<Integer, String> GENDER_MAP;

    static {
        Map<Integer, String> map = Arrays.stream(values()).collect(Collectors.toMap(PubFormCustomerGenderEnum::getCode, PubFormCustomerGenderEnum::getDescription));
        GENDER_MAP = Collections.unmodifiableMap(map);
    }
}
