package cn.com.duiba.oto.dto.oto.wx.wxmessage.result;

import cn.com.duiba.oto.bean.wx.WxBaseResponse;
import cn.com.duiba.oto.enums.WxErrorCodeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * Created by xiaotian on 2019/2/1.
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString(callSuper=true)
public class WechatResultBean extends WxBaseResponse implements Serializable {

    private static final long serialVersionUID = 350723056201135289L;
    private String content;

    public static WechatResultBean configNotSend(){
        WechatResultBean wechatResultBean = new WechatResultBean();
        wechatResultBean.setErrCode(-3L);
        wechatResultBean.setErrMsg("配置不发送消息");
        return wechatResultBean;
    }


    public static WechatResultBean functionDown(){
        WechatResultBean wechatResultBean = new WechatResultBean();
        wechatResultBean.setErrCode(-6L);
        wechatResultBean.setErrMsg("功能下线");
        return wechatResultBean;
    }

    public static WechatResultBean asyncSend(){
        WechatResultBean wechatResultBean = new WechatResultBean();
        wechatResultBean.setErrCode(WxErrorCodeEnum.E_11.getCode());
        wechatResultBean.setErrMsg(WxErrorCodeEnum.E_11.getDesc());
        return wechatResultBean;
    }

    public static WechatResultBean unSupport() {
        WechatResultBean wechatResultBean = new WechatResultBean();
        wechatResultBean.setErrCode(WxErrorCodeEnum.E_12.getCode());
        wechatResultBean.setErrMsg(WxErrorCodeEnum.E_12.getDesc());
        return wechatResultBean;
    }

}
