package cn.com.duiba.oto.oto.service.api.remoteservice.company.ref;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.product.ProductCompanyRelationDto;
import cn.com.duiba.oto.param.oto.product.ProductCompanyRelationSearchParam;

import java.util.List;

/**
 * @author liuyj
 * @date 2022/6/28 10:16
 */
@AdvancedFeignClient
public interface RemoteProductCompanyRelationService {
    /**
     * 批量保存
     * @param params 参数
     * @return 结果
     */
    boolean batchSave(List<ProductCompanyRelationSearchParam> params);

    /**
     * 根据产品组ID删除产品组和产品的关联关系
     * @param companyId 公司ID
     * @return 结果
     */
    boolean deleteByCompanyId(Long companyId);

    /**
     * 根据不同查询条件获取数据结果集
     * @param param 查询参数
     * @return 结果集
     */
    List<ProductCompanyRelationDto> selectList(ProductCompanyRelationSearchParam param);
}
