package cn.com.duiba.oto.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * OTO-任务来源
 *
 * @author liuyajun
 */
@Getter
@AllArgsConstructor
public enum OtoCustPlanSourceEnum {

    CHECK_DETAIL(1, "盘点计划"),
    SELLER_SELF(2, "自建计划");

    private Integer code;

    private String desc;

    private static final Map<Integer, String> MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustPlanSourceEnum::getCode, OtoCustPlanSourceEnum::getDesc, (v1, v2) -> v1)));


    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return MAP.get(code);
    }
}
