package cn.com.duiba.oto.enums.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 您希望退休后每个月的养老生活费是多少
 * @Author meichang
 * @Date 2022/5/18 19:53
 * @Version 1.0
 */
@AllArgsConstructor
@Getter
public enum OtoCustPensionCostEnum {
    TEN_THOUSAND(1, "1万元"),
    TWENTY_THOUSAND(2, "2万元"),
    THIRTY_THOUSAND(3, "3万元"),
    FIFTY_THOUSAND(4, "5万元"),
    FIFTY_THOUSAND_ON(5, "5万元以上"),
    NONE(0, "尚未选择");


    /**
     * 编码
     */
    private final Integer code;

    /**
     * 备注
     */
    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustPensionCostEnum::getCode, OtoCustPensionCostEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据状态获取描述
     */
    public static String getDescByStatus(Integer status){
        if (status == null) {
            return null;
        }
        return ALL_MAP.get(status);
    }
}
