package cn.com.duiba.oto.enums.deal;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 成单：保单状态
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum DealStatusEnum {

    UNDERWRITE(1, "承保"),
    BOGGLE(2, "犹退"),
    FULL_REFUND(3, "全额退保"),
    LIMIT_PRICE_REFUND(4, "限价退保"),
    ;

    private static final Map<Integer, DealStatusEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(DealStatusEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    ;


    private final Integer code;
    private final String desc;

    DealStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DealStatusEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
