package cn.com.duiba.oto.enums.pet;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 宠物服务类型
 *
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum PetWashTypeEnum {

    //赛级洗护
    COMPETITION_WASH(0, 0L, 0, "https://yun.tuisnake.com/jjb-pet-weapp/202506/qlfqj7kk8wpj8qtriqkrz.png", "赛级洗护"),
    //基础洗护
    BASIC_WASH(1, 0L, 0, "https://yun.tuisnake.com/jjb-pet-weapp/202506/qlfqj7kk8wpj8qtriqkrz.png", "基础洗护"), //开结
    OPEN_JOINT(2, 5000L, 1, "https://yun.tuisnake.com/jjb-pet-weapp/202506/pcepaei4owbmedevizacz.png", "开结"), //局部去油
    LOCAL_DEOILING(3, 5000L, 2, "https://yun.tuisnake.com/jjb-pet-weapp/202506/xgy4g8id2osdeawf3daj4.png", "局部去油"), //药浴
    MEDICATED_BATH(4, 8000L, 3, "https://yun.tuisnake.com/jjb-pet-weapp/202506/qtdyggzxbd7d6zzr_vj4c.png", "药浴"), //全身去油
    WHOLE_BODY_DEOILING(5, 10000L, 4, "https://yun.tuisnake.com/jjb-pet-weapp/202506/ogdkmzbwtpfirdstxyk53.png", "全身去油"), //刷牙
    BRUSH_TEETH(6, 2000L, 5, "https://yun.tuisnake.com/jjb-pet-weapp/202506/jktbvuxnenojszw1wt5s7.png", "刷牙"), //局部剃毛
    LOCAL_BARBERING(7, 3000L, 6, "https://yun.tuisnake.com/jjb-pet-weapp/202506/xtimwvqjmcrobwlw_rpbz.png", "局部剃毛"), //全身去废毛
    LOW_PRICE_SHAVING(9, 2000L, 7, "https://yun.tuisnake.com/jjb-pet-weapp/202506/yvuegjcpkfunpf7e1kjq6.png", "贵宾脚"),//贵宾脚
    WHOLE_BODY_SHAVING(8, 12000L, 8, "https://yun.tuisnake.com/jjb-pet-weapp/202506/pa-xozu0qtx-xwxo3eikn.png", "全身剃毛"),
    WHOLE_BODY_BARBERING(9, 8000L, 9, "https://yun.tuisnake.com/jjb-pet-weapp/202506/-qp7ls4ah_fpcrvmt63om.png", "深度除毛"), //全身剃毛
    ;

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PetWashTypeEnum::getCode, PetWashTypeEnum::getDesc, (v1, v2) -> v1)));
    private static final Map<Integer, Long> CUSTOMER_PRICE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PetWashTypeEnum::getCode, PetWashTypeEnum::getPrice, (v1, v2) -> v1)));

    private Integer code;
    private Long price;
    private Integer order;
    private String icon;
    private String desc;

    public Long getPrice() {
        if (SpringEnvironmentUtils.isProdEnv()) {
            return price;
        } else {
            return price / 1000;
        }
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }

    public static Long getPriceByCode(Integer code) {
        if (code == null) {
            return 0L;
        }
        return CUSTOMER_PRICE_MAP.get(code);
    }
}
