package cn.com.duiba.oto.enums.system;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：
 *
 *
 * @Auther: xiaotian
 * @Date: 2025/6/11 10:03
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PropertyActivityConfigBean extends SystemConfigBaseParamBean {

    private static final long serialVersionUID = -8652681855579942229L;

    /**
     * 子项
     */
    private List<SubListBean> subList;

    @Data
    public static class SubListBean implements Serializable {
        private static final long serialVersionUID = 2763015183009143451L;
        /**
         * 顺序
         */
        private Integer index;

        /**
         * 活动类型：自定义活动类型，必须
         *
         * @link BizActivityTypeEnum.WUYE_AVTIVITY.getType() 开头
         */
        private String activityType;

        /**
         * 活动名称
         */
        private String activityName;

        /**
         * 活动图片
         */
        private String activityImg;

        /**
         * 小区名称
         */
        private String community;

        /**
         * 集合时间
         */
        private String activityDateDesc;

        /**
         * 集合地址
         */
        private String activityAddressDesc;

        /**
         * 活动名额
         */
        private String activityNum;

        /**
         * 分享图片
         */
        private String shareImg;

        /**
         * 分享标题
         */
        private String shareTitle;
    }

}
