package cn.com.duiba.oto.dto.oto.amount;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

/**
 * 用户立减金实体类
 *
 * @author songp
 * @date 2024/8/14 9:52 AM
 */
public class UserRemainAmountDto implements Serializable {

    private static final long serialVersionUID = 16540625622786852L;

    /**
     * 剩余立减金(单位：分)
     */
    private long remainAmount;

    /**
     * 未失效的立减金记录
     */
    private List<ExpireAmountRecordDto> effectiveAmountRecords;

    public long getRemainAmount() {
        return remainAmount;
    }

    public void setRemainAmount(long remainAmount) {
        this.remainAmount = remainAmount;
    }

    public List<ExpireAmountRecordDto> getEffectiveAmountRecords() {
        return effectiveAmountRecords;
    }

    public void setEffectiveAmountRecords(List<ExpireAmountRecordDto> effectiveAmountRecords) {
        this.effectiveAmountRecords = effectiveAmountRecords;
    }

    /**
     * 获取指定金额立减金记录
     * @param amount 指定金额
     * @return 立减金记录
     */
    public List<ExpireAmountRecordDto> getAppointAmountRecords(Long amount) {
        if (amount > remainAmount || remainAmount <= 0) {
            return Collections.emptyList();
        }

        List<ExpireAmountRecordDto> recordDtos = effectiveAmountRecords.stream()
                .sorted(Comparator.comparing(ExpireAmountRecordDto::getExpireTime))
                .collect(Collectors.toList());

        List<ExpireAmountRecordDto> newRecordDtos = new ArrayList<>();
        AtomicLong incr = new AtomicLong(0L);
        for (ExpireAmountRecordDto recordDto : recordDtos) {
            newRecordDtos.add(recordDto);
            // 21 10 10 10 10
            if (incr.addAndGet(recordDto.getRemainAmount()) >= amount) {
                break;
            }
        }

        return newRecordDtos;
    }
}
