package cn.com.duiba.oto.oto.service.api.remoteservice.deal;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.deal.DealOrderDto;
import cn.com.duiba.oto.dto.oto.deal.InsuranceProductsDto;
import cn.com.duiba.oto.param.oto.deal.RemoteSearchDealParam;
import cn.com.duiba.oto.util.PageResult;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2024-07-22 10:00
 */
@AdvancedFeignClient
public interface RemoteDealOrderService {

    /**
     * 筛选保单列表
     *
     * @return 部门列表
     */
    PageResult<DealOrderDto> list(RemoteSearchDealParam searchDealParam);

    /**
     * 新增/编辑部门
     *
     * @return 是否成功
     */
    Boolean saveOrUpdate(DealOrderDto dealOrderDto) throws BizException;

    /**
     * 获取保单详情
     */
    DealOrderDto detail(Long id);

    /**
     * 获取自己看见的客户保单列表
     */
    List<DealOrderDto> custDealList(Long sellerId, Long custId);

    /**
     * 获取所有保险产品
     *
     * @return
     */
    List<InsuranceProductsDto> allProducts();
}
