package cn.com.duiba.oto.dto.oto.wx.wxmessage;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Map;

/**
 * Created by xiaotian on 2020-02-07.
 *  发送目标客户对象
 */
@Data
public class MessageUserDto implements BaseMessageUserDto {
    private static final long serialVersionUID = -5993475953485160587L;

    /**
     * 发送目标客户的open ID
     */
    @NotBlank(message = "openId 不能为空")
    private String openId;

    /**
     * 公众号ID
     */
    private Long oaId;

    /**
     * 微信昵称
     */
    private String nickName;

    /**
     * 每个用户不同的额外参数
     */
    private Map<String,Serializable> customMap;
    /**
     * 自定义日志参数
     */
    private Map<String,Serializable> customLogMap;
}
